#include "explosive.h"
#include "particle.h"

Explosive::Explosive(Object *parent, Texture *particle, int power) : Material(parent) {
	this->particle = particle;
	this->power = power;
}

void Explosive::removeLink(Link *l) {
	Material::removeLink(l);

	int i;
	float cx, cy;
	float ix, iy;
	cx = (l->a->x + l->b->x) * 0.5f;
	cy = (l->a->y + l->b->y) * 0.5f;

	for(i = 0; i < rand() % power; i++) {
		ix = (l->a->x - l->a->ox + l->b->x - l->b->ox) * 0.5f + (rand() % 100) * 0.1f - 5.0f;
		iy = (l->a->y - l->a->oy + l->b->y - l->b->oy) * 0.5f + (rand() % 100) * 0.1f - 5.0f;

		Atom *a = new Atom(cx, cy, 1.0f, ix, iy, 0);
		new Particle(this, a, particle, 30 + rand() % 20, 20.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f, -1.0f);
	}
}